﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Runtime.CompilerServices;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using Microsoft.VisualBasic.CompilerServices;

namespace Darkminer_v6
{
	// Token: 0x02000044 RID: 68
	[DesignerGenerated]
	public partial class Form7 : Form
	{
		// Token: 0x060002AE RID: 686 RVA: 0x00016D98 File Offset: 0x00014F98
		public Form7()
		{
			base.Load += this.Form7_Load;
			this.cancellationTokenSource = new CancellationTokenSource();
			this.random = new Random();
			this.tries = 0;
			this.isMining = false;
			this.foundCount = 0;
			this.words = new string[]
			{
				"person",
				"offer",
				"year",
				"chain",
				"road",
				"head",
				"content",
				"work",
				"world",
				"flat",
				"code",
				"law",
				"source",
				"table",
				"parrot",
				"key",
				"deep",
				"family",
				"luck",
				"gold",
				"thing",
				"picture",
				"island",
				"foot",
				"spring",
				"object",
				"oak",
				"squirrel",
				"peace",
				"orange",
				"windmill",
				"side",
				"star",
				"sun",
				"tree",
				"water",
				"apple",
				"book",
				"chair",
				"dog",
				"elephant",
				"flower",
				"guitar",
				"hat",
				"ice cream",
				"jelly",
				"table",
				"lamp",
				"computer",
				"shoe",
				"keyboard",
				"candle",
				"window",
				"car",
				"bicycle",
				"phone",
				"pencil",
				"pen",
				"globe",
				"clock",
				"mirror",
				"television",
				"camera",
				"pillow",
				"blanket",
				"guitar",
				"keyboard",
				"flower",
				"lamp",
				"couch",
				"window",
				"door",
				"table",
				"coffee",
				"mug",
				"cookie",
				"cake",
				"candy",
				"jacket",
				"hat",
				"scarf",
				"gloves",
				"umbrella",
				"rain",
				"sun",
				"moon",
				"star",
				"cloud",
				"tree",
				"river",
				"mountain",
				"beach",
				"ocean",
				"lake",
				"forest",
				"desert",
				"island",
				"ship",
				"airplane",
				"train",
				"bus",
				"subway",
				"taxi",
				"hotel",
				"restaurant",
				"library",
				"school",
				"university",
				"hospital",
				"doctor",
				"nurse",
				"police",
				"firefighter",
				"teacher",
				"student",
				"artist",
				"musician",
				"actor",
				"director",
				"writer",
				"dancer",
				"chef",
				"scientist",
				"engineer",
				"programmer",
				"designer",
				"athlete",
				"singer",
				"athlete",
				"politician",
				"lawyer",
				"judge",
				"journalist",
				"photographer",
				"veterinarian",
				"architect"
			};
			this.textBuilder = new StringBuilder();
			this.InitializeComponent();
		}

		// Token: 0x170000CD RID: 205
		// (get) Token: 0x060002B1 RID: 689 RVA: 0x000036F2 File Offset: 0x000018F2
		// (set) Token: 0x060002B2 RID: 690 RVA: 0x00017C88 File Offset: 0x00015E88
		internal virtual Button StartButton
		{
			[CompilerGenerated]
			get
			{
				return this._StartButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StartButton_Click);
				Button startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click -= value2;
				}
				this._StartButton = value;
				startButton = this._StartButton;
				if (startButton != null)
				{
					startButton.Click += value2;
				}
			}
		}

		// Token: 0x170000CE RID: 206
		// (get) Token: 0x060002B3 RID: 691 RVA: 0x000036FC File Offset: 0x000018FC
		// (set) Token: 0x060002B4 RID: 692 RVA: 0x00017CCC File Offset: 0x00015ECC
		internal virtual Button StopButton
		{
			[CompilerGenerated]
			get
			{
				return this._StopButton;
			}
			[CompilerGenerated]
			[MethodImpl(MethodImplOptions.Synchronized)]
			set
			{
				EventHandler value2 = new EventHandler(this.StopButton_Click);
				Button stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click -= value2;
				}
				this._StopButton = value;
				stopButton = this._StopButton;
				if (stopButton != null)
				{
					stopButton.Click += value2;
				}
			}
		}

		// Token: 0x170000CF RID: 207
		// (get) Token: 0x060002B5 RID: 693 RVA: 0x00003706 File Offset: 0x00001906
		// (set) Token: 0x060002B6 RID: 694 RVA: 0x00003710 File Offset: 0x00001910
		internal virtual RichTextBox ResultRichTextBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D0 RID: 208
		// (get) Token: 0x060002B7 RID: 695 RVA: 0x00003719 File Offset: 0x00001919
		// (set) Token: 0x060002B8 RID: 696 RVA: 0x00003723 File Offset: 0x00001923
		internal virtual CheckBox EthCheckBox { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D1 RID: 209
		// (get) Token: 0x060002B9 RID: 697 RVA: 0x0000372C File Offset: 0x0000192C
		// (set) Token: 0x060002BA RID: 698 RVA: 0x00003736 File Offset: 0x00001936
		internal virtual Label RecordCountLabel { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D2 RID: 210
		// (get) Token: 0x060002BB RID: 699 RVA: 0x0000373F File Offset: 0x0000193F
		// (set) Token: 0x060002BC RID: 700 RVA: 0x00003749 File Offset: 0x00001949
		internal virtual RichTextBox Izpis { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D3 RID: 211
		// (get) Token: 0x060002BD RID: 701 RVA: 0x00003752 File Offset: 0x00001952
		// (set) Token: 0x060002BE RID: 702 RVA: 0x0000375C File Offset: 0x0000195C
		internal virtual Label Found { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D4 RID: 212
		// (get) Token: 0x060002BF RID: 703 RVA: 0x00003765 File Offset: 0x00001965
		// (set) Token: 0x060002C0 RID: 704 RVA: 0x0000376F File Offset: 0x0000196F
		internal virtual PictureBox PictureBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D5 RID: 213
		// (get) Token: 0x060002C1 RID: 705 RVA: 0x00003778 File Offset: 0x00001978
		// (set) Token: 0x060002C2 RID: 706 RVA: 0x00003782 File Offset: 0x00001982
		internal virtual PictureBox PictureBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D6 RID: 214
		// (get) Token: 0x060002C3 RID: 707 RVA: 0x0000378B File Offset: 0x0000198B
		// (set) Token: 0x060002C4 RID: 708 RVA: 0x00003795 File Offset: 0x00001995
		internal virtual PictureBox PictureBox6 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D7 RID: 215
		// (get) Token: 0x060002C5 RID: 709 RVA: 0x0000379E File Offset: 0x0000199E
		// (set) Token: 0x060002C6 RID: 710 RVA: 0x000037A8 File Offset: 0x000019A8
		internal virtual CheckBox CheckBox1 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D8 RID: 216
		// (get) Token: 0x060002C7 RID: 711 RVA: 0x000037B1 File Offset: 0x000019B1
		// (set) Token: 0x060002C8 RID: 712 RVA: 0x000037BB File Offset: 0x000019BB
		internal virtual CheckBox CheckBox2 { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x170000D9 RID: 217
		// (get) Token: 0x060002C9 RID: 713 RVA: 0x000037C4 File Offset: 0x000019C4
		// (set) Token: 0x060002CA RID: 714 RVA: 0x000037CE File Offset: 0x000019CE
		private virtual System.Windows.Forms.Timer timer { get; [MethodImpl(MethodImplOptions.Synchronized)] set; }

		// Token: 0x060002CB RID: 715 RVA: 0x00017D10 File Offset: 0x00015F10
		private void Form7_Load(object sender, EventArgs e)
		{
			this.ResultRichTextBox.ReadOnly = true;
			this.ResultRichTextBox.BackColor = Color.Black;
			this.ResultRichTextBox.Font = new Font(SystemFonts.DefaultFont.FontFamily, 12f);
			this.ResultRichTextBox.WordWrap = false;
			System.Windows.Forms.Timer timer = new System.Windows.Forms.Timer();
			timer.Tick += this.InternetCheckTimer_Tick;
			timer.Interval = 5000;
			timer.Start();
		}

		// Token: 0x060002CC RID: 716 RVA: 0x00017D98 File Offset: 0x00015F98
		private void InternetCheckTimer_Tick(object sender, EventArgs e)
		{
			bool flag = this.CheckForInternetConnection();
			bool flag2 = !flag;
			if (flag2)
			{
				this.StopMining();
			}
		}

		// Token: 0x060002CD RID: 717 RVA: 0x00017DC0 File Offset: 0x00015FC0
		private void StopMining()
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x060002CE RID: 718 RVA: 0x00017E2C File Offset: 0x0001602C
		private void AppendTextWithScroll(string text, Color color, bool isBold, float fontSize)
		{
			bool invokeRequired = this.ResultRichTextBox.InvokeRequired;
			if (invokeRequired)
			{
				this.ResultRichTextBox.Invoke(delegate()
				{
					this.AppendTextWithScroll(text, color, isBold, fontSize);
				});
			}
			else
			{
				this.ResultRichTextBox.SelectionColor = color;
				bool $VB$Local_isBold = isBold;
				if ($VB$Local_isBold)
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Bold);
				}
				else
				{
					this.ResultRichTextBox.SelectionFont = new Font(this.ResultRichTextBox.Font.FontFamily, fontSize, FontStyle.Regular);
				}
				this.textBuilder.Append(text + " ");
				bool flag = text.EndsWith("\r\n");
				if (flag)
				{
					this.ResultRichTextBox.AppendText(this.textBuilder.ToString().TrimEnd() + Environment.NewLine);
					this.ResultRichTextBox.ScrollToCaret();
					this.textBuilder.Clear();
				}
				this.UpdateRecordCountLabel();
			}
		}

		// Token: 0x060002CF RID: 719 RVA: 0x00004E60 File Offset: 0x00003060
		private bool CheckForInternetConnection()
		{
			bool result;
			try
			{
				WebRequest webRequest = WebRequest.Create("http://www.google.com");
				WebResponse response = webRequest.GetResponse();
				result = true;
			}
			catch (Exception ex)
			{
				result = false;
			}
			return result;
		}

		// Token: 0x060002D0 RID: 720 RVA: 0x000037D7 File Offset: 0x000019D7
		private void UpdateRecordCountLabel()
		{
			this.RecordCountLabel.Text = string.Format("Checked: {0}", this.ResultRichTextBox.Lines.Length);
		}

		// Token: 0x060002D1 RID: 721 RVA: 0x00017F7C File Offset: 0x0001617C
		private async void StartButton_Click(object sender, EventArgs e)
		{
			Form7._Closure$__69-0 CS$<>8__locals1 = new Form7._Closure$__69-0(CS$<>8__locals1);
			CS$<>8__locals1.$VB$Me = this;
			bool flag = this.isMining;
			if (!flag)
			{
				CS$<>8__locals1.$VB$Local_selectedCrypto = "";
				bool @checked = this.EthCheckBox.Checked;
				if (@checked)
				{
					CS$<>8__locals1.$VB$Local_selectedCrypto = "BTC";
					bool validCrypto = false;
					bool flag2 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0 || Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
					if (flag2)
					{
						validCrypto = true;
						this.isMining = true;
						this.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.Green, true, 16f);
						await Task.Run(checked(delegate()
						{
							int num = 0;
							while (!CS$<>8__locals1.$VB$Me.cancellationTokenSource.Token.IsCancellationRequested)
							{
								bool flag3 = CS$<>8__locals1.$VB$Me.tries > CS$<>8__locals1.$VB$Me.random.Next(1500, 1000000000);
								if (flag3)
								{
									string text = Form7.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									bool flag4 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "ETH", false) == 0;
									List<string> list;
									int num3;
									unchecked
									{
										if (flag4)
										{
											double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 2.9 + 0.1, 4);
										}
										else
										{
											bool flag5 = Operators.CompareString(CS$<>8__locals1.$VB$Local_selectedCrypto, "BTC", false) == 0;
											if (flag5)
											{
												double num2 = Math.Round(CS$<>8__locals1.$VB$Me.random.NextDouble() * 0.99 + 0.01, 4);
											}
										}
										list = new List<string>();
										num3 = 0;
									}
									do
									{
										bool flag6 = num3 < CS$<>8__locals1.$VB$Me.words.Length;
										if (flag6)
										{
											list.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										}
										num3++;
									}
									while (num3 <= 11);
									string text2 = string.Format("Wallet check:     {0}", string.Join(" ", list));
									text2 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text2, Color.White, false, 8f);
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.tries = 0;
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll("Wallet check:   luck foot star sun flat person sun content tree parrot luck offer", Color.White, false, 8f);
									Thread.Sleep(1);
								}
								else
								{
									string text3 = Form7.id_gen(38, "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789");
									List<string> list2 = new List<string>();
									int num4 = 0;
									do
									{
										list2.Add(CS$<>8__locals1.$VB$Me.words[CS$<>8__locals1.$VB$Me.random.Next(CS$<>8__locals1.$VB$Me.words.Length)]);
										num4++;
									}
									while (num4 <= 11);
									string text4 = string.Format("Wallet check:   {0}", string.Join(" ", list2));
									text4 += "\r\n";
									Thread.Sleep(1);
									CS$<>8__locals1.$VB$Me.AppendTextWithScroll(text4, Color.White, false, 10f);
									Form7 $VB$Me = CS$<>8__locals1.$VB$Me;
									ref int ptr = ref $VB$Me.tries;
									$VB$Me.tries = ptr + 1;
									num++;
								}
							}
						}));
					}
					if (!validCrypto)
					{
						MessageBox.Show("Please choose a valid currency (ETH or BTC).", "Invalid Currency", MessageBoxButtons.OK, MessageBoxIcon.Hand);
					}
				}
				else
				{
					MessageBox.Show("Please select all blockchains.", "Invalid Blockchain", MessageBoxButtons.OK, MessageBoxIcon.Hand);
				}
			}
		}

		// Token: 0x060002D2 RID: 722 RVA: 0x00017DC0 File Offset: 0x00015FC0
		private void StopButton_Click(object sender, EventArgs e)
		{
			bool flag = this.isMining;
			if (flag)
			{
				this.cancellationTokenSource.Cancel();
				try
				{
					this.cancellationTokenSource.Token.ThrowIfCancellationRequested();
				}
				catch (OperationCanceledException ex)
				{
				}
				this.isMining = false;
				Application.Exit();
			}
		}

		// Token: 0x060002D3 RID: 723 RVA: 0x00017FC4 File Offset: 0x000161C4
		private static string id_gen(int size = 38, string chars = "AbCdEfGhIjkLMnOpQrStUvWxYz0123456789")
		{
			Random random = new Random();
			return new string((from s in Enumerable.Repeat<string>(chars, size)
			select s[random.Next(s.Length)]).ToArray<char>());
		}

		// Token: 0x0400020A RID: 522
		private CancellationTokenSource cancellationTokenSource;

		// Token: 0x0400020B RID: 523
		private Random random;

		// Token: 0x0400020C RID: 524
		private int tries;

		// Token: 0x0400020D RID: 525
		private bool isMining;

		// Token: 0x0400020F RID: 527
		private int foundCount;

		// Token: 0x04000210 RID: 528
		private string[] words;

		// Token: 0x04000211 RID: 529
		private StringBuilder textBuilder;
	}
}
